function Tanja(A,b)
format long


[n,m]=size(A);
vec=length(b);

%provera slaganja
if (n~=m)
  error('Greska: Matrica mora biti kvadratna!') 
    return
end

if (n~=vec)
    error('Greska: Dimenzije matrice i vektora se ne uklapaju!');
    return
end

%resenja
%Uporedna resenja: 

%Uz pomoc nase funkcije resenje sistema A*x=b je: 
nase=LUfunkcija(A,b,n);
nase
%Uz pomoc lu() funkcije resenje sistema A*x=b je: 
[M,N,P]=lu(A);
komp=N\(M\(P*b));
komp


i=1;
while i<=100
 A=rand(n,n);
 b=rand(n,1);
 if det(A)~=0
  P=LUfunkcija(A,b,n);
  Tabela(1,i)=norm(A\b-P); %norma razlike 2 resenja 
  Tabela(2,i)=cond(A);     %uslovljenost matrice
  i=i+1;
 end
end

%sortiramo uslovljenosti matrica, koje ce biti na x osi  
for i=1:99
    for j=(i+1):100
        if Tabela(2,j) < Tabela(2,i)
            priv=Tabela(:,j);
            Tabela(:,j)=Tabela(:,i);
            Tabela(:,i)=priv;
        end
    end
end

%iscrtavanje grafa
line(Tabela(2,:),Tabela(1,:),'Color','b','LineWidth',1);
title('GRAF u zavisnosti od slucajno izabranih matrica');
xlabel('Uslovljenost matrice');
ylabel('Norma razlike resenja');



function P=LUfunkcija(A,b,n)

%dekompozicija Krautovim algoritmom
U=0;
for i=1:n
 U(1,i)=A(1,i);
 L(i,1)=A(i,1)./U(1,1);
end
for i=2:n
    for k=i:n
        PomSuma=0;
        for j=1:i-1
            PomSuma=PomSuma+L(i,j).*U(j,k);
        end
        U(i,k)=A(i,k)-PomSuma;
    end
    for k=i+1:n
        PomSuma=0;
        for j=1:i-1
            PomSuma=PomSuma+L(k,j).*U(j,i);
        end
        L(k,i)=(A(k,i)-PomSuma)./U(i,i);
    end
end

%resavanje sistema
P1=0;
for i=1:n
    PomSuma=0;
    for j=1:i-1
        PomSuma=PomSuma+L(i,j).*P1(j,1);
    end
    P1(i,1)=b(i,1)-PomSuma;
end

P=0;
for i=n:-1:1
    PomSuma=0;
    for j=n:-1:i+1
        PomSuma=PomSuma+U(i,j).*P(j,1);
    end
    P(i,1)=(P1(i,1)-PomSuma)./U(i,i);
end
